---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：138-Pod Security Admission

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **PSP後継の記述**：公式ドキュメントとの整合確認
  2. **ポリシー評価の詳細**：policy/ パッケージの詳細な読み込みが未完了

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/pod-security-admission/admission/admission.go` - Admission 本体
- E-02: Kubernetes API ラベル定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Admission 構造体の依存コンポーネント | E-01 (53-73行目) | ○ |
| C-02 | 3種類のValidate分岐 | E-01 (213-224行目) | ○ |
| C-03 | defaultPodSpecResources に9種類のリソース | E-01 (94-104行目) | ○ |
| C-04 | DefaultPodSpecExtractor の switch 文 | E-01 (112-135行目) | ○ |
| C-05 | defaultNamespaceMaxPodsToCheck = 3000 | E-01 (47行目) | ○ |
| C-06 | defaultNamespacePodCheckTimeout = 1秒 | E-01 (48行目) | ○ |
| C-07 | CompleteConfiguration でデフォルト補完 | E-01 (153-169行目) | ○ |
| C-08 | ValidateConfiguration で必須フィールドチェック | E-01 (172-203行目) | ○ |
| C-09 | ValidateNamespace でラベル検証 | E-01 (229行目以降) | ○ |
| C-10 | NamespaceGetter インターフェース | E-01 (75-77行目) | ○ |
| C-11 | PodLister インターフェース | E-01 (79-81行目) | ○ |
| C-12 | PodSpecExtractor インターフェース | E-01 (85-92行目) | ○ |
| C-13 | CronJob は入れ子で PodSpec 抽出 | E-01 (130-131行目) | ○ |
| C-14 | enforce/audit/warn の3モード | E-01 (213-224行目、Validate内分岐) | ○ |
| C-15 | Privileged/Baseline/Restricted の3レベル | E-01 (コメント・インポート) | ○ |
| C-16 | Metrics recorder が必須 | E-01 (187-188行目) | ○ |
| C-17 | PSP の後継 | **根拠なし** | △ |
| C-18 | ポリシー評価の具体的チェック項目 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PSP 後継であることの公式ドキュメントソース
  - 候補：KEP-2579 / Kubernetes公式ドキュメント
- ポリシー評価の具体的チェック項目一覧
  - 候補：`staging/src/k8s.io/pod-security-admission/policy/` パッケージ内のチェック実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Admission Controller の構造は正確
- 1: 中リスク - ポリシー評価の具体的内容は policy/ パッケージの詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Namespace 除外設定の方法が正確に記述されているか
- [ ] 各セキュリティレベルのチェック項目が網羅されているか
- [ ] audit/warn の結果がどのように記録されるかの詳細
